#ifdef _VERSION_CHECK_
	#ifndef MSET
		#ifndef _NOT_INSTANCED_
		
			#version 120
			#extension GL_EXT_gpu_shader4 : enable          

		#endif
	#endif
#endif

#ifdef SKINNING

	uniform mat3 	boneMatrices[100];
				
#endif

#ifndef _NOT_INSTANCED_
	uniform samplerBuffer 	WorldPoses;
#endif

varying mat3	TBN;				

varying vec2 			texcoord,
						alphacoord;
//attribute vec4			binormal; 

vec4 					outNormal,
						outTangent,
						outBinormal; 
uniform vec4			coordMod;
uniform vec4 			colorMod;	
uniform vec2			NF;
uniform float 			fade;
uniform float 			alphalevel;
varying float			fadeAlpha;

attribute vec3			s2_vertex;
attribute vec3			s2_normal;
attribute vec4			s2_binormal;
attribute vec4			s2_color;
attribute vec4  		s2_secondaryColor;
attribute vec4			s2_texcoords; 
	
//uniform float	bias;
	
vec2 ComputeFrame(float dt, vec2 nf)
{
	vec2 ofs=vec2(1.0,1.0)/nf;
	float frame=floor(dt*nf.x*nf.y);
	float row=floor(frame/nf.x);
	float col=floor(frame-nf.x*row);
	
	return vec2(ofs.x*col, 1.0-(ofs.y*row)-ofs.y);
}

void main()
{
	vec4 normal4      	= vec4( s2_normal, 0.0 );
	vec4 binormal4      = vec4( s2_binormal.xyz, 0.0 );
	vec4 tangent4      	= vec4(cross(binormal4.xyz,normal4.xyz),0.0);
	binormal4.xyz*=s2_binormal.w;
	
	vec4 vertex			= vec4(s2_vertex,1.0);
  
#ifdef SKINNING

	vec4 index  		= s2_secondaryColor;
	vec4 weight 		= s2_color;
	vec4 position   	= vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 tempNormal  	= vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 tempTangent  	= vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 tempBinormal  	= vec4( 0.0, 0.0, 0.0, 0.0 );
	
	mat4 TM=mat4(	0.0,0.0,0.0,0.0,
					0.0,0.0,0.0,0.0,
					0.0,0.0,0.0,0.0,
					0.0,0.0,0.0,1.0);

	int j;
  	for( int i = 0; i < 4; i++ )
 	{
		j=int(index[i]);
		TM[0].xyz=boneMatrices[j][0];
		TM[1].xyz=boneMatrices[j][1];
		TM[2].xyz=cross(TM[0].xyz,TM[1].xyz);
		TM[3].xyz=boneMatrices[j][2];
		
		position = position + (TM * vertex) *weight[i];
			
		// Transform normals by bone i
		TM[3]=vec4(0,0,0,1);
  	    tempNormal = tempNormal + (TM * normal4)*weight[i];
		tempBinormal = tempBinormal + (TM * binormal4)*weight[i];
		tempTangent = tempTangent + (TM * tangent4)*weight[i];
	}
	
	//position.xyz=position.xyz+s2_normal.xyz*bias;
	gl_Position = gl_ModelViewProjectionMatrix * position;
	//gl_Position.z-=bias;

	normal4=tempNormal;
	tangent4=tempTangent;
	binormal4=tempBinormal;
	
	texcoord = s2_texcoords.st;
		
	outNormal=gl_ModelViewMatrix*normal4;
	outTangent=gl_ModelViewMatrix*tangent4;
	outBinormal=gl_ModelViewMatrix*binormal4; 

	normalize(outNormal);
	normalize(outTangent);
	normalize(outBinormal);

	TBN[0]=outTangent.xyz;
	TBN[1]=outBinormal.xyz;
	TBN[2]=outNormal.xyz;
	
#else

	#ifndef _NOT_INSTANCED_
	
		mat4 MTX;
		int index=gl_InstanceID*4;
		MTX[0]=texelFetchBuffer(WorldPoses,index);
		MTX[1]=texelFetchBuffer(WorldPoses,index+1);
		MTX[2]=texelFetchBuffer(WorldPoses,index+2);
		MTX[3]=texelFetchBuffer(WorldPoses,index+3);
		fadeAlpha=MTX[3].w;
		MTX[3].w=1.0;
					
		//vertex.xyz=vertex.xyz+s2_normal.xyz*bias;	
		vertex.xyz=(MTX*vertex).xyz;//+(MTX*normal4).xyz*bias;			
		//vec4 pos=MTX*vertex;
		gl_Position = (gl_ModelViewProjectionMatrix)*vertex;//*pos; 
		
		texcoord = (s2_texcoords.st*coordMod.xy) + coordMod.zw;	
		alphacoord	= s2_texcoords.st;
				
		MTX=gl_ModelViewMatrix*MTX;
		outNormal=MTX*normal4;
		outTangent=MTX*tangent4;
		outBinormal=MTX*binormal4; 
	
		vec4 pos=/*MTX*/gl_ModelViewMatrix*vertex;
		float dist=(length(pos.xyz)-fadeAlpha*0.8)/(fadeAlpha*0.2);
		dist=(1.0 - (clamp(dist,0.0,1.0)));
		fadeAlpha=dist*alphalevel*colorMod.a; 
		
		gl_Position.z-=0.1*dist;//bias;
		
	#else

		//vertex.xyz=vertex.xyz+s2_normal.xyz*bias;
		gl_Position = (gl_ModelViewProjectionMatrix)*vertex;
		//gl_Position.z-=bias;
		
		texcoord = (s2_texcoords.st*coordMod.xy) + coordMod.zw;	
		alphacoord	= s2_texcoords.st;
					
		outNormal=gl_ModelViewMatrix*normal4;
		outTangent=gl_ModelViewMatrix*tangent4;
		outBinormal=gl_ModelViewMatrix*binormal4; 
		
		vec4 pos=gl_ModelViewMatrix*vertex;
		float dist=(length(pos.xyz)-fade*0.8)/(fade*0.2);
		dist=(1.0 - (clamp(dist,0.0,1.0)));
		fadeAlpha=dist*alphalevel*colorMod.a; 
		
		gl_Position.z-=0.1*dist;

	#endif
	
	normalize(outNormal);
	normalize(outTangent);
	normalize(outBinormal);

	TBN[0]=outTangent.xyz;
	TBN[1]=outBinormal.xyz;
	TBN[2]=outNormal.xyz;

#endif	
}